/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.util.codec.CustomizationCodecs;

public class BlockFamily {
    public static final Codec<BlockFamily> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter($ -> true), (App)class_5321.method_39154((class_5321)class_7924.field_41254).listOf().optionalFieldOf("blocks", List.of()).forGetter($ -> $.blockHolders().stream().map(class_6880.class_6883::method_40237).toList()), (App)class_5321.method_39154((class_5321)class_7924.field_41197).listOf().optionalFieldOf("items", List.of()).forGetter($ -> $.itemHolders().stream().map(class_6880.class_6883::method_40237).toList()), (App)CustomizationCodecs.compactList(class_5321.method_39154((class_5321)class_7924.field_41197)).optionalFieldOf("exchange_inputs_in_viewer", List.of()).forGetter($ -> $.exchangeInputsInViewer().stream().map(class_6880.class_6883::method_40237).toList()), (App)Codec.BOOL.optionalFieldOf("stonecutter_exchange", (Object)false).forGetter(BlockFamily::stonecutterExchange), (App)class_5321.method_39154((class_5321)class_7924.field_41197).optionalFieldOf("stonecutter_from").forGetter($ -> $.stonecutterSource().map(class_6880.class_6883::method_40237)), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("stonecutter_from_multiplier", (Object)1).forGetter(BlockFamily::stonecutterSourceMultiplier), (App)SwitchAttrs.CODEC.optionalFieldOf("switch", (Object)SwitchAttrs.DISABLED).forGetter(BlockFamily::switchAttrs)).apply((Applicative)instance, BlockFamily::new));
    private final List<class_6880.class_6883<class_2248>> blocks;
    private final List<class_6880.class_6883<class_1792>> items;
    private final List<class_6880.class_6883<class_1792>> exchangeInputsInViewer;
    private final boolean stonecutterExchange;
    private final Optional<class_6880.class_6883<class_1792>> stonecutterFrom;
    private final int stonecutterFromMultiplier;
    private final SwitchAttrs switchAttrs;
    private class_1856 ingredient;
    private class_1856 ingredientInViewer;

    public BlockFamily(boolean strict, List<class_5321<class_2248>> blocks, List<class_5321<class_1792>> items, List<class_5321<class_1792>> exchangeInputsInViewer, boolean stonecutterExchange, Optional<class_5321<class_1792>> stonecutterFrom, int stonecutterFromMultiplier, SwitchAttrs switchAttrs) {
        this.blocks = blocks.stream().map($ -> {
            Optional holder = class_7923.field_41175.method_40264($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Block %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get).toList();
        this.items = Stream.concat(this.blocks.stream().map(class_6880::comp_349).map(class_1935::method_8389).filter(Predicate.not(class_1802.field_8162::equals)).mapToInt(arg_0 -> ((class_7922)class_7923.field_41178).method_10206(arg_0)).distinct().mapToObj(arg_0 -> ((class_7922)class_7923.field_41178).method_40265(arg_0)).map(Optional::orElseThrow), items.stream().map($ -> {
            Optional holder = class_7923.field_41178.method_40264($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Item %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get)).toList();
        this.exchangeInputsInViewer = exchangeInputsInViewer.stream().map($ -> {
            Optional holder = class_7923.field_41178.method_40264($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Item %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get).toList();
        this.stonecutterExchange = stonecutterExchange;
        this.stonecutterFrom = stonecutterFrom.map($ -> {
            Optional holder = class_7923.field_41178.method_40264($);
            if (strict) {
                Preconditions.checkArgument((boolean)holder.isPresent(), (String)"Item %s not found", (Object)$);
            }
            return holder;
        }).filter(Optional::isPresent).map(Optional::get);
        this.stonecutterFromMultiplier = stonecutterFromMultiplier;
        this.switchAttrs = switchAttrs;
        Preconditions.checkArgument((!blocks.isEmpty() || !items.isEmpty() ? 1 : 0) != 0, (Object)"No entries found in family");
        Preconditions.checkArgument((this.blocks().distinct().count() == (long)this.blocks.size() ? 1 : 0) != 0, (String)"Duplicate blocks found in family %s", (Object)this);
        Preconditions.checkArgument((this.items().distinct().count() == (long)this.items.size() ? 1 : 0) != 0, (String)"Duplicate items found in family %s", (Object)this);
    }

    public List<class_6880.class_6883<class_2248>> blockHolders() {
        return this.blocks;
    }

    public List<class_6880.class_6883<class_1792>> itemHolders() {
        return this.items;
    }

    public List<class_6880.class_6883<class_1792>> exchangeInputsInViewer() {
        return this.exchangeInputsInViewer;
    }

    public Stream<class_2248> blocks() {
        return this.blocks.stream().map(class_6880::comp_349);
    }

    public Stream<class_1792> items() {
        return this.items.stream().map(class_6880::comp_349);
    }

    public boolean stonecutterExchange() {
        return this.stonecutterExchange;
    }

    public Optional<class_6880.class_6883<class_1792>> stonecutterSource() {
        return this.stonecutterFrom;
    }

    public int stonecutterSourceMultiplier() {
        return this.stonecutterFromMultiplier;
    }

    public class_1856 stonecutterSourceIngredient() {
        return this.stonecutterFrom.map(holder -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)holder.comp_349()})).orElse(class_1856.field_9017);
    }

    public SwitchAttrs switchAttrs() {
        return this.switchAttrs;
    }

    protected class_1856 toIngredient(List<? extends class_6880<class_1792>> items) {
        return class_1856.method_8091((class_1935[])((class_1935[])items.stream().map(class_6880::comp_349).filter(item -> BlockFamilies.getConvertRatio(item) >= 1.0f).toArray(class_1935[]::new)));
    }

    public class_1856 ingredient() {
        if (this.ingredient == null) {
            this.ingredient = this.toIngredient(this.items);
        }
        return this.ingredient;
    }

    public class_1856 ingredientInViewer() {
        if (this.ingredientInViewer == null) {
            this.ingredientInViewer = this.exchangeInputsInViewer.isEmpty() ? this.ingredient() : this.toIngredient(this.exchangeInputsInViewer);
        }
        return this.ingredientInViewer;
    }

    public boolean contains(class_1792 item) {
        return this.items.stream().anyMatch(h -> ((class_1792)h.comp_349()).method_8389() == item);
    }

    public String toString() {
        return "BlockFamily{blocks=" + this.blocks + ", items=" + this.items + ", stonecutterFrom=" + this.stonecutterFrom + "}";
    }

    public record SwitchAttrs(boolean enabled, boolean cascading, boolean creativeOnly) {
        public static final Codec<SwitchAttrs> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(SwitchAttrs::enabled), (App)Codec.BOOL.optionalFieldOf("cascading", (Object)false).forGetter(SwitchAttrs::cascading), (App)Codec.BOOL.optionalFieldOf("creative_only", (Object)false).forGetter(SwitchAttrs::creativeOnly)).apply((Applicative)instance, SwitchAttrs::create));
        public static final SwitchAttrs DISABLED = new SwitchAttrs(false, false, false);
        private static final Interner<SwitchAttrs> INTERNER = Interners.newStrongInterner();

        public static SwitchAttrs create(boolean enabled, boolean cascading, boolean creativeOnly) {
            if (!enabled) {
                Preconditions.checkArgument((!cascading ? 1 : 0) != 0, (Object)"Cascading switch must be disabled if switch is disabled");
                Preconditions.checkArgument((!creativeOnly ? 1 : 0) != 0, (Object)"Creative only switch must be disabled if switch is disabled");
                return DISABLED;
            }
            return (SwitchAttrs)INTERNER.intern((Object)new SwitchAttrs(true, cascading, creativeOnly));
        }
    }
}

